<?php
session_start();
require_once('../Connections/oprmConn.php');

if (!isset($_SESSION['user_id'])) {
    header("Location: ../index.php");
    exit;
}

if (isset($_REQUEST['timesheetid'])) {
    $l = "timesheet-edit.php?timesheet_id=" . rawurlencode($_REQUEST['timesheetid']) . "&token=" . rawurlencode($_REQUEST['token']);
    header("Location: $l");
    exit;
}

$ipaddress = $_SERVER['REMOTE_ADDR'] ?? '';

// Helper: safe escape
function esc($conn, $v) {
    return mysqli_real_escape_string($conn, (string)$v);
}

// Backward-compatible GetSQLValueString rewritten for mysqli
if (!function_exists("GetSQLValueString")) {
    function GetSQLValueString($theValue, $theType, $theDefinedValue = "", $theNotDefinedValue = "") {
        global $oprmConn;
        $theValue = isset($theValue) ? $theValue : "";

        switch ($theType) {
            case "text":
                $theValue = ($theValue !== "") ? "'" . mysqli_real_escape_string($oprmConn, $theValue) . "'" : "NULL";
                break;
            case "long":
            case "int":
                $theValue = ($theValue !== "") ? intval($theValue) : "NULL";
                break;
            case "double":
                $theValue = ($theValue !== "") ? "'" . doubleval($theValue) . "'" : "NULL";
                break;
            case "date":
                $theValue = ($theValue !== "") ? "'" . mysqli_real_escape_string($oprmConn, $theValue) . "'" : "NULL";
                break;
            case "defined":
                $theValue = ($theValue !== "") ? $theDefinedValue : $theNotDefinedValue;
                break;
            default:
                $theValue = "NULL";
        }
        return $theValue;
    }
}

/* =========== handle GET week prefetch =========== */
if (isset($_GET['week'])) {
    $week = esc($oprmConn, $_GET['week']);
    $year = esc($oprmConn, $_GET['year'] ?? '');
    $session_user = esc($oprmConn, $_SESSION['user_id']);

    $query_getWeek = "SELECT DISTINCT(project_id) FROM weby_timesheets 
        WHERE task_week = '$week' 
          AND task_year = '$year' 
          AND user_id = '$session_user' 
          AND status IN ('I','B') 
        ORDER BY project_id ASC";

    $getWeek = mysqli_query($oprmConn, $query_getWeek) or die(mysqli_error($oprmConn));
    $row_getWeek = mysqli_fetch_assoc($getWeek);
    $totalRows_getWeek = mysqli_num_rows($getWeek);
} else {
    $getWeek = null;
    $row_getWeek = null;
    $totalRows_getWeek = 0;
}

/* =========== POST: Save as Draft =========== */
if (isset($_POST['save'])) {
    $count = isset($_GET['count']) ? intval($_GET['count']) : 0;
    $week_number = $_POST['week'] ?? '';
    $year = $_POST['year'] ?? '';
    for ($m = 0; $m <= $count; $m++) {
        if ($m > 0) {
            $varprj = "project" . $m;
            $varclient = "client" . $m;
        } else {
            $varprj = "project";
            $varclient = "client";
        }

        $project = $_POST[$varprj] ?? 0;
        $client = $_POST[$varclient] ?? '';

        if (($project != 0) && ($client != '')) {
            $user = $_SESSION['user_id'];

            $project_esc = esc($oprmConn, $project);
            $week_esc = esc($oprmConn, $week_number);
            $year_esc = esc($oprmConn, $year);
            $user_esc = esc($oprmConn, $user);

            $query_PendingGalleries = "SELECT * FROM weby_timesheets 
                WHERE project_id = '$project_esc' 
                  AND task_week = '$week_esc' 
                  AND task_year = '$year_esc' 
                  AND user_id = '$user_esc'";
            $PendingGalleries = mysqli_query($oprmConn, $query_PendingGalleries) or die(mysqli_error($oprmConn));
            $row_PendingGalleries = mysqli_fetch_assoc($PendingGalleries);
            $totalRows_PendingGalleries = mysqli_num_rows($PendingGalleries);

            for ($w = 1; $w <= 7; $w++) {
                $dtt = date('Y-m-d', strtotime($year . "W" . $week_number . $w));
                if ($m > 0) {
                    $vart1 = "total_hrs" . $w . $m;
                } else {
                    $vart1 = "total_hrs" . $w;
                }
                $total_hrs = $_POST[$vart1] ?? 0;
                $pt = $project;
                $user_id = $_SESSION['user_id'];
                $token = rand(15420, 999898);
                $status = "I";

                $pt_esc = esc($oprmConn, $pt);
                $dtt_esc = esc($oprmConn, $dtt);
                $user_id_esc = esc($oprmConn, $user_id);
                $total_hrs_esc = esc($oprmConn, $total_hrs);
                $client_esc = esc($oprmConn, $client);
                $token_esc = esc($oprmConn, $token);
                $ip_esc = esc($oprmConn, $ipaddress);
                $status_esc = esc($oprmConn, $status);

                $query_getFirst = "SELECT * FROM weby_timesheets WHERE task_week = '$week_esc' AND task_year = '$year_esc' AND created_date = '$dtt_esc' AND project_id = '$pt_esc' AND user_id = '$user_id_esc' AND status IN ('I','B')";
                $getFirst = mysqli_query($oprmConn, $query_getFirst) or die(mysqli_error($oprmConn));
                $row_getFirst = mysqli_fetch_assoc($getFirst);
                $totalRows_getFirst = mysqli_num_rows($getFirst);

                if ($totalRows_getFirst > 0) {
                    $query_Recordset1 = "UPDATE weby_timesheets SET project_id = '$pt_esc', client_id = '$client_esc', total_hrs = '$total_hrs_esc', ip_address = '$ip_esc', status = '$status_esc', updated_by = '$user_id_esc', token = '$token_esc' WHERE task_week = '$week_esc' AND task_year = '$year_esc' AND created_date = '$dtt_esc' AND project_id = '$pt_esc' AND user_id = '$user_id_esc' AND status IN ('I','B')";
                    $Recordset1 = mysqli_query($oprmConn, $query_Recordset1) or die(mysqli_error($oprmConn));
                } else {
                    $query_getEdit = "SELECT * FROM weby_timesheets WHERE task_week = '$week_esc' AND task_year = '$year_esc' AND created_date = '$dtt_esc' AND project_id = '$pt_esc' AND user_id = '$user_id_esc' AND status IN ('A','Q')";
                    $getEdit = mysqli_query($oprmConn, $query_getEdit) or die(mysqli_error($oprmConn));
                    $row_getEdit = mysqli_fetch_assoc($getEdit);
                    $totalRows_getEdit = mysqli_num_rows($getEdit);

                    if ($totalRows_getEdit == 0) {
                        $qu = "INSERT INTO weby_timesheets (user_id,project_id,client_id,total_hrs,task_week,task_year,ip_address,status,created_by,created_date,updated_by,token) VALUES ('$user_id_esc','$pt_esc','$client_esc','$total_hrs_esc','$week_esc','$year_esc','$ip_esc','$status_esc','$user_id_esc','$dtt_esc','$user_id_esc','$token_esc')";
                        $getProj = mysqli_query($oprmConn, $qu) or die(mysqli_error($oprmConn));
                    }
                }
            } // end for days

            $msg = "Timesheet Saved to Drafts Successfully";
            header("Location: timesheet.php?msgdr=" . rawurlencode($msg));
            exit;
        } else if ($project == 0) {
            $msg = "No Project Selected";
            header("Location: timesheet-view.php?week=" . rawurlencode($week_number) . "&year=" . rawurlencode($year) . "&msgdg=" . rawurlencode($msg));
            exit;
        } else if ($client == '') {
            $msg = "No Client Selected";
            header("Location: timesheet-view.php?week=" . rawurlencode($week_number) . "&year=" . rawurlencode($year) . "&msgdg=" . rawurlencode($msg));
            exit;
        }
    } // end for projects
} // end save

/* =========== POST: Submit =========== */
if (isset($_POST['submit'])) {
    $count = isset($_GET['count']) ? intval($_GET['count']) : 0;
    $week_number = $_POST['week'] ?? '';
    $year = $_POST['year'] ?? '';

    for ($m = 0; $m <= $count; $m++) {
        if ($m > 0) {
            $varprj = "project" . $m;
            $varclient = "client" . $m;
        } else {
            $varprj = "project";
            $varclient = "client";
        }

        $project = $_POST[$varprj] ?? 0;
        $client = $_POST[$varclient] ?? '';

        if (($project != 0) && ($client != '')) {
            $user = $_SESSION['user_id'];

            for ($w = 1; $w <= 7; $w++) {
                $dtt = date('Y-m-d', strtotime($year . "W" . $week_number . $w));
                if ($m > 0) {
                    $vart1 = "total_hrs" . $w . $m;
                } else {
                    $vart1 = "total_hrs" . $w;
                }
                $total_hrs = $_POST[$vart1] ?? 0;
                $pt = $project;
                $d = isset($_POST['date']) ? date("Y-m-d", strtotime($_POST['date'])) : date("Y-m-d");
                $user_id = $_SESSION['user_id'];
                $token = rand(15420, 999898);
                $status = "A";

                $pt_esc = esc($oprmConn, $pt);
                $dtt_esc = esc($oprmConn, $dtt);
                $user_id_esc = esc($oprmConn, $user_id);
                $total_hrs_esc = esc($oprmConn, $total_hrs);
                $client_esc = esc($oprmConn, $client);
                $token_esc = esc($oprmConn, $token);
                $ip_esc = esc($oprmConn, $ipaddress);
                $status_esc = esc($oprmConn, $status);
                $week_esc = esc($oprmConn, $week_number);
                $year_esc = esc($oprmConn, $year);

                $query_getFirst = "SELECT * FROM weby_timesheets WHERE task_week = '$week_esc' AND task_year = '$year_esc' AND created_date = '$dtt_esc' AND project_id = '$pt_esc' AND user_id = '$user_id_esc' AND status IN ('I','B')";
                $getFirst = mysqli_query($oprmConn, $query_getFirst) or die(mysqli_error($oprmConn));
                $row_getFirst = mysqli_fetch_assoc($getFirst);
                $totalRows_getFirst = mysqli_num_rows($getFirst);

                if ($totalRows_getFirst > 0) {
                    $query_Recordset1 = "UPDATE weby_timesheets SET project_id = '$pt_esc', client_id = '$client_esc', total_hrs = '$total_hrs_esc', ip_address = '$ip_esc', status = '$status_esc', updated_by = '$user_id_esc', token = '$token_esc' WHERE task_week = '$week_esc' AND task_year = '$year_esc' AND created_date = '$dtt_esc' AND project_id = '$pt_esc' AND user_id = '$user_id_esc' AND status IN ('I','B')";
                    $Recordset1 = mysqli_query($oprmConn, $query_Recordset1) or die(mysqli_error($oprmConn));
                } else {
                    $query_getEdit = "SELECT * FROM weby_timesheets WHERE task_week = '$week_esc' AND task_year = '$year_esc' AND created_date = '$dtt_esc' AND project_id = '$pt_esc' AND user_id = '$user_id_esc' AND status IN ('A','Q')";
                    $getEdit = mysqli_query($oprmConn, $query_getEdit) or die(mysqli_error($oprmConn));
                    $row_getEdit = mysqli_fetch_assoc($getEdit);
                    $totalRows_getEdit = mysqli_num_rows($getEdit);

                    if ($totalRows_getEdit == 0) {
                        $qu = "INSERT INTO weby_timesheets (user_id,project_id,client_id,total_hrs,task_week,task_year,ip_address,status,created_by,created_date,updated_by,token) VALUES ('$user_id_esc','$pt_esc','$client_esc','$total_hrs_esc','$week_esc','$year_esc','$ip_esc','$status_esc','$user_id_esc','$dtt_esc','$user_id_esc','$token_esc')";
                        $getProj = mysqli_query($oprmConn, $qu) or die(mysqli_error($oprmConn));
                    }
                }

                // after insert/update, prepare mail info (if any)
            } // end for days

            // prepare email / project info
            $tid = $row_getFirst['timesheet_id'] ?? null;
            if ($tid) {
                $tid_esc = esc($oprmConn, $tid);
                $q = "SELECT weby_profiles.full_name, weby_timesheets.created_date, weby_timesheets.timesheet_id, weby_timesheets.project_id, weby_timesheets.total_hrs, weby_timesheets.hr_rate, weby_timesheets.total_amount, weby_timesheets.task_week, weby_timesheets.status, weby_projects.project_name, weby_users.email_address FROM weby_timesheets, weby_profiles, weby_projects, weby_users WHERE weby_timesheets.timesheet_id = '$tid_esc' AND weby_timesheets.user_id = weby_profiles.user_id AND weby_users.user_id = weby_profiles.user_id AND weby_profiles.user_id = weby_timesheets.user_id AND weby_projects.projetc_id = weby_timesheets.project_id";
                $getProj = mysqli_query($oprmConn, $q) or die(mysqli_error($oprmConn));
                $row_getTime = mysqli_fetch_assoc($getProj);
                $totalRows_getProj = mysqli_num_rows($getProj);

                $query_getProj22 = "SELECT email_address FROM weby_users WHERE user_role = 1";
                $getProj22 = mysqli_query($oprmConn, $query_getProj22) or die(mysqli_error($oprmConn));
                $row_getProj22 = mysqli_fetch_assoc($getProj22);
                $totalRows_getProj22 = mysqli_num_rows($getProj22);

                $s = "InActive";
                if (isset($row_getTime['status'])) {
                    if ($row_getTime['status'] == "A") $s = "Approved";
                    if ($row_getTime['status'] == "P") $s = "Pending";
                    if ($row_getTime['status'] == "D") $s = "Deleted";
                }

                require_once('timesheet-view-mail.php');
            }

            $msg = "Timesheet Submited Successfully";
            header("Location: timesheet.php?&msg=" . rawurlencode($msg));
            exit;
        } else if ($project == 0) {
            $msg = "No Project Selected";
            header("Location: timesheet-edit.php?week=" . rawurlencode($week_number) . "&year=" . rawurlencode($year) . "&msgdg=" . rawurlencode($msg));
            exit;
        } else if ($client == '') {
            $msg = "No Client Selected";
            header("Location: timesheet-edit.php?week=" . rawurlencode($week_number) . "&year=" . rawurlencode($year) . "&msgdg=" . rawurlencode($msg));
            exit;
        }
    } // end for m
} // end submit

/* =========== queries for page rendering (profile, projects etc) =========== */

$query_getRes = "SELECT weby_users.user_id, weby_users.email_address, weby_users.caeated_date, weby_profiles.profile_id, weby_profiles.full_name, weby_profiles.job_title, weby_profiles.skill_set, weby_profiles.profile_pic, weby_profiles.hr_rate FROM weby_users, weby_profiles WHERE weby_profiles.user_id = weby_users.user_id AND weby_users.user_id = '" . esc($oprmConn, $_SESSION['user_id']) . "'";
$getRes = mysqli_query($oprmConn, $query_getRes) or die(mysqli_error($oprmConn));
$row_getRes = mysqli_fetch_assoc($getRes);
$totalRows_getRes = mysqli_num_rows($getRes);

$query_getProj = "SELECT * FROM weby_projects WHERE weby_projects.status = 'A' AND weby_projects.projetc_id IN (SELECT DISTINCT project_id FROM weby_users_projects WHERE status = 'A' AND user_id = '" . esc($oprmConn, $_SESSION['user_id']) . "')";
$getProj = mysqli_query($oprmConn, $query_getProj) or die(mysqli_error($oprmConn));
$row_getProj = mysqli_fetch_assoc($getProj);
$totalRows_getProj = mysqli_num_rows($getProj);

$query_getTotalproj = "SELECT * FROM weby_users_projects WHERE user_id = '" . esc($oprmConn, $_SESSION['user_id']) . "' AND status = 'A'";
$getTotalproj = mysqli_query($oprmConn, $query_getTotalproj) or die(mysqli_error($oprmConn));
$row_getTotalproj = mysqli_fetch_assoc($getTotalproj);
$totalRows_getTotalproj = mysqli_num_rows($getTotalproj);

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Icon Consultancy Services Ltd - Tool Resource Time sheet</title>
<style>
.act_timesheet {
    background: #373938;
    color: #fff;
}
</style>
<link rel="stylesheet" href="../css/style.css" type="text/css">
<link rel="stylesheet" href="//code.jquery.com/ui/1.10.4/themes/smoothness/jquery-ui.css">
<script src="//code.jquery.com/jquery-1.10.2.js"></script>
<script src="//code.jquery.com/ui/1.9.1/jquery-ui.js"></script>
<script src="../../js/jquery.flexslider.js"></script>
<script language="JavaScript">
window.gcount = <?php echo max(0, intval($totalRows_getWeek) - 1); ?>;
jQuery(function($){
    var $repeater0 = $('#repeater0');
    var $project = $('#project');
    var $selectproj = $('#selectproj');
    var $selectclient = $('#selectclient');
    var $field_item = $('#field_item');

    $('#addemail').click(function(e){
        e.preventDefault();
        var count = window.gcount + 1;
        window.gcount = count;
        <?php $dr = intval($totalRows_getTotalproj) - intval($totalRows_getWeek); ?>
        if (count > <?php echo ($dr > 0) ? ($totalRows_getTotalproj - 1) : $dr; ?>) {
            alert("That's enough already!");
            return;
        }
        var idname = 'repeater0' + count;
        var $repeatero = $('#repeater0').clone().attr({id: idname});
        $repeater0.append($repeatero);
    });
    $('#removeButton').click(function(e){
        e.preventDefault();
        var count = window.gcount;
        if (count == 0) { alert("Can not remove all projects!"); return; }
        $('#repeater0' + count).remove();
        window.gcount = count - 1;
    });
});
</script>

<script>
function setVisibility(id, visibility) {
    var el = document.getElementById(id);
    if (el) el.style.display = visibility;
}
</script>

<script>
function validateForm() {
    document.getElementById('submit_timesheet').action = 'timesheet-edit.php?' + "count=" + gcount;

    var totals = [0,0,0,0,0,0,0];
    <?php for ($i=0; $i <= $totalRows_getTotalproj; $i++) {
        $ii = ($i==0) ? '' : $i;
    ?>
    var totalhr1 = parseFloat((document.getElementById('total_hrs1<?php echo $ii;?>') || {value:0}).value) || 0;
    totals[0] += totalhr1;
    var totalhr2 = parseFloat((document.getElementById('total_hrs2<?php echo $ii;?>') || {value:0}).value) || 0;
    totals[1] += totalhr2;
    var totalhr3 = parseFloat((document.getElementById('total_hrs3<?php echo $ii;?>') || {value:0}).value) || 0;
    totals[2] += totalhr3;
    var totalhr4 = parseFloat((document.getElementById('total_hrs4<?php echo $ii;?>') || {value:0}).value) || 0;
    totals[3] += totalhr4;
    var totalhr5 = parseFloat((document.getElementById('total_hrs5<?php echo $ii;?>') || {value:0}).value) || 0;
    totals[4] += totalhr5;
    var totalhr6 = parseFloat((document.getElementById('total_hrs6<?php echo $ii;?>') || {value:0}).value) || 0;
    totals[5] += totalhr6;
    var totalhr7 = parseFloat((document.getElementById('total_hrs7<?php echo $ii;?>') || {value:0}).value) || 0;
    totals[6] += totalhr7;
    <?php } ?>

    for (var d = 0; d < 7; d++) {
        if (totals[d] > 24) {
            alert("Effort totals per day should be less than 24hrs");
            return false;
        }
    }
    return true;
}
</script>
</head>

<body>
<!-- Wrapper Starts -->
<div class="wrapper">
  <?php require_once('../includes/header.php'); ?>
  <?php require_once('../includes/tools-menu.php'); ?>

  <article class="inside_wrapper clear_fix">
    <section class="main_content">
      <h1>Edit Time sheet</h1>
      <article class="resource_timesheet clear_fix">
        <form method="post" action="#" id="submit_timesheet" name="submit_timesheet" onsubmit="return validateForm()">
          <div class="field_item">
          <label>Week:</label>
          <?php
            echo '<select name="week" id="week" onChange="redirect();">';
            $i = 1;
            $pweek = date('W');
            $year_param = $_GET['year'] ?? date('Y');

            while ($i <= 52) {
                if ($i < 10) {
                    $value = "value='0" . $i . "'";
                } else {
                    $value = "value='" . $i . "'";
                }
                if (isset($_GET['week'])) {
                    $gwk = ($i < 10) ? sprintf("%02s", $i) : $i;
                    if ($i == intval($_GET['week'])) {
                        $dwk = date('d M, Y', strtotime($year_param . "W" . $gwk . '7'));
                        echo '<option ' . $value . ' selected="selected">' . 'W/e ' . $dwk . '</option>';
                    }
                }
                $i++;
            }

            $query_MAXHrs = "SELECT weekly_hrs FROM weby_users WHERE user_id = '" . esc($oprmConn, $_SESSION['user_id']) . "'";
            $MAXHrs = mysqli_query($oprmConn, $query_MAXHrs) or die(mysqli_error($oprmConn));
            $row_MAXHrs = mysqli_fetch_assoc($MAXHrs);
            $totalRows_MAXHrs = mysqli_num_rows($MAXHrs);

            echo '</select></div>';
          ?>
          <input type="hidden" name="year" id="year" value="<?php echo htmlspecialchars($_GET['year'] ?? ''); ?>" />
          <input type="hidden" name="cnt" id="cnt" value="0" />
          <?php if (isset($_GET['week'])) { ?>
          <div class="total_hours">
            <label id="weekth" style="width:160px;">Week Hours:
              <?php
                $query_getHrs = "SELECT SUM(`total_hrs`) AS sumhrs FROM weby_timesheets WHERE task_year = '" . esc($oprmConn, $_GET['year']) . "' AND task_week = '" . esc($oprmConn, $_GET['week']) . "' AND user_id = '" . esc($oprmConn, $_SESSION['user_id']) . "' AND status != 'D'";
                $getHrs = mysqli_query($oprmConn, $query_getHrs) or die(mysqli_error($oprmConn));
                $row_getHrs = mysqli_fetch_assoc($getHrs);
                echo $row_getHrs['sumhrs'] ?? 0;
              ?>
            </label>
            <label id="weekth" style="width:160px;"><b><?php echo 'MAX Hrs Allowed: ' . ($row_MAXHrs['weekly_hrs'] ?? '0'); ?></b></label>
          </div>
          <div class="clear-fix">&nbsp;</div>

          <?php
            $n = 0;
            if ($getWeek) {
                // We already fetched $row_getWeek, now iterate do/while style
                do {
                    // use safe project id
                    $projectId = $row_getWeek['project_id'];
                    $proj_esc = esc($oprmConn, $projectId);

                    $query_getPdtls = "SELECT * FROM weby_timesheets WHERE project_id = '$proj_esc' AND user_id = '" . esc($oprmConn, $_SESSION['user_id']) . "'";
                    $getPdtls = mysqli_query($oprmConn, $query_getPdtls) or die(mysqli_error($oprmConn));
                    $row_getPdtls = mysqli_fetch_assoc($getPdtls);
                    $totalRows_getPdtls = mysqli_num_rows($getPdtls);

                    $displayIndex = ($n != 0) ? $n : '';
          ?>
          <div>
            <div id="repeater0<?php echo $displayIndex; ?>">
            <div class="field_item" id="field_item">
            <input type="hidden" name="asgprj" id="asgprj" value="<?php echo intval($totalRows_getTotalproj); ?>" />
            <label id="selectproj">Project Name:</label>
            <select name="project<?php echo $displayIndex; ?>" id="project<?php echo $displayIndex; ?>">
            <?php
                $query_getprjname = "SELECT * FROM weby_projects WHERE projetc_id = '" . esc($oprmConn, $projectId) . "'";
                $getprjname = mysqli_query($oprmConn, $query_getprjname) or die(mysqli_error($oprmConn));
                $row_getprjname = mysqli_fetch_assoc($getprjname);
                $totalRows_getprjname = mysqli_num_rows($getprjname);
            ?>
            <option value="0">Select Project</option>
            <?php
                // iterate full project list ($getProj) — we reset pointer each loop
                if ($totalRows_getProj > 0) {
                    mysqli_data_seek($getProj, 0);
                    while ($row = mysqli_fetch_assoc($getProj)) {
                        $sel = ($row['projetc_id'] == ($row_getprjname['projetc_id'] ?? null)) ? 'selected="selected"' : '';
                        echo '<option value="' . htmlspecialchars($row['projetc_id']) . '" ' . $sel . '>' . htmlspecialchars($row['project_name']) . '</option>';
                    }
                }
            ?>
            </select>
            </div>

            <label id="weekproth" style="width:140px;">Project Total Hours:
            <?php
                $query_getHrs = "SELECT SUM(`total_hrs`) AS sumhrs FROM weby_timesheets WHERE task_year = '" . esc($oprmConn, $_GET['year']) . "' AND task_week = '" . esc($oprmConn, $_GET['week']) . "' AND user_id = '" . esc($oprmConn, $_SESSION['user_id']) . "' AND project_id = '" . $proj_esc . "' AND status != 'D'";
                $getHrs = mysqli_query($oprmConn, $query_getHrs) or die(mysqli_error($oprmConn));
                $row_getHrs = mysqli_fetch_assoc($getHrs);
                echo intval($row_getHrs['sumhrs'] ?? 0);
            ?>
            </label>

            <div class="field_item" id="field_item" style="display:none;">
            <label id="selectclient">Select Client:</label>
            <select name="client1" id="client1">
            <option value="0">Select Client</option>
            <?php
                $query_getcid = "SELECT * FROM weby_timesheets WHERE project_id = '" . $proj_esc . "' AND task_week = '" . esc($oprmConn, $_GET['week']) . "' AND task_year = '" . esc($oprmConn, $_GET['year']) . "' AND user_id = '" . esc($oprmConn, $_SESSION['user_id']) . "' AND status IN ('I','B') ORDER BY created_date ASC";
                $getcid = mysqli_query($oprmConn, $query_getcid) or die(mysqli_error($oprmConn));
                $row_getcid = mysqli_fetch_assoc($getcid);

                $query_getclients = "SELECT * FROM weby_clients WHERE status = 'A'";
                $getclients = mysqli_query($oprmConn, $query_getclients) or die(mysqli_error($oprmConn));
                while ($row_getclients = mysqli_fetch_assoc($getclients)) {
                    $sel = ($row_getclients['client_id'] == ($row_getcid['client_id'] ?? null)) ? 'selected' : '';
                    echo '<option value="' . htmlspecialchars($row_getclients['client_id']) . '" ' . $sel . '>' . htmlspecialchars($row_getclients['client_name']) . '</option>';
                }
            ?>
            </select>
            </div>

            <input type="hidden" value="0" name="client" id="client">
            <div class="field_item">
                <div class="timesheet_tablet">
                  <div class="column_titlet">
                    <?php
                        $week_number = $_GET['week'];
                        $year = $_GET['year'];
                        for ($day = 1; $day <= 7; $day++) {
                            $dwk = date('d-m-Y', strtotime($year . "W" . $week_number . $day));
                            $dayn = date('D', strtotime($year . "W" . $week_number . $day));
                            echo '<span class="item_smalltt" style="width:79px; font-size:12px;">' . htmlspecialchars($dayn) . '</span>';
                        }
                    ?>
                  </div>

                  <?php
                    $week_number = $_GET['week'];
                    $year = $_GET['year'];
                    for ($day = 1; $day <= 7; $day++) {
                        $dwk = date('d-m-Y', strtotime($year . "W" . $week_number . $day));
                        echo '<span class="item_smallt" style="width:79px; font-size:12px;" name="datewk' . $day . '" id="datewk' . $day . '">' . htmlspecialchars($dwk) . '<br />9:00AM-5:00PM</span>';
                    }
                  ?>
                </div>

                <div class="timesheet_tablet">
                  <?php
                    $query_getHors = "SELECT * FROM weby_timesheets WHERE project_id = '" . $proj_esc . "' AND task_week = '" . esc($oprmConn, $_GET['week']) . "' AND task_year = '" . esc($oprmConn, $_GET['year']) . "' AND user_id = '" . esc($oprmConn, $_SESSION['user_id']) . "' AND status IN ('I','B') ORDER BY created_date ASC";
                    $getHors = mysqli_query($oprmConn, $query_getHors) or die(mysqli_error($oprmConn));
                    $day = 1;
                    while ($row_getHors = mysqli_fetch_assoc($getHors)) {
                        echo '<span class="item_smallt" style="width:79px; font-size:12px;">';
                        $inpName = 'total_hrs' . $day . $displayIndex;
                        $idName = 'total_hrs' . $day . $displayIndex;
                        echo '<input type="text" name="' . htmlspecialchars($inpName) . '" id="' . htmlspecialchars($idName) . '" maxlength="4" size="4" value="' . htmlspecialchars($row_getHors['total_hrs']) . '" />';
                        echo '<input type="hidden" name="id' . $day . $displayIndex . '" id="id' . $day . $displayIndex . '" value="' . htmlspecialchars($row_getHors['timesheet_id']) . '" />';
                        echo '</span>';
                        $day++;
                    }
                  ?>
                </div>
              </div>
              <div class="clear-fix">&nbsp;</div>
            </div>
            <div class="clear-fix">&nbsp;</div>
          </div>
          <?php
                    $n++;
                } while ($row_getWeek = mysqli_fetch_assoc($getWeek));
            } // end if $getWeek
          ?>

          <?php if ($totalRows_getTotalproj > $totalRows_getWeek) { ?>
          <input type="button" style="margin-left:120px;" id="addemail" class="add" value="Add" />
          <input type="button" class="remove" value="Remove" name="removeButton" id="removeButton" />
          <?php } ?>

          <div class="clear-fix">&nbsp;</div>
          <div class="submt">
            <div class="action_items">
              <input name="save" id="save" type="submit" class="save_btn" value="Save as Draft">
              <?php if ((isset($_GET['year']) && intval($_GET['year']) < date('Y')) || (isset($_GET['year']) && intval($_GET['year']) == date('Y') && intval($_GET['week']) < date('W'))) { ?>
              <input type="submit" name="submit" id="submit" value="Submit to Admin" class="reset_btn">
              <?php } ?>
              <input type="reset" value="Cancel" class="reset_btn" onClick="window.location='timesheet.php';">
            </div>
          </div>
          <?php } // end if isset week ?>
        </form>
        <div class="clear-fix">&nbsp;</div>
      </article>
    </section>

    <aside class="sidebar">
      <div class="featured clear_fix">
        <h2 class="white_txt">My Profile</h2>
        <div class="profile_box">
          <a href="resources-view.php?resourceid=<?php echo htmlspecialchars($row_getRes['user_id'] ?? ''); ?>"><img src="/RM/images/<?php echo !empty($row_getRes['profile_pic']) ? htmlspecialchars($row_getRes['profile_pic']) : 'black-img.jpg'; ?>" width="68" /></a>
          <p class="profile_title"><a href="resources-view.php?resourceid=<?php echo htmlspecialchars($row_getRes['user_id'] ?? ''); ?>"><?php echo htmlspecialchars($row_getRes['full_name'] ?? ''); ?></a><span class="desig"><br /><?php echo htmlspecialchars($row_getRes['job_title'] ?? ''); ?></span></p>
          <p class="profile_desc"><?php echo htmlspecialchars($row_getRes['skill_set'] ?? ''); ?></p>
          <div class="clear-fix">&nbsp;</div>
        </div>
      </div>
    </aside>

    <div class="clear-fix">&nbsp;</div>
  </article>

  <div class="clear-fix">&nbsp;</div>
  <?php require_once('../includes/footer.php'); ?>
</div>
</body>
</html>

<?php
// free results if set
if (isset($getRes) && $getRes) mysqli_free_result($getRes);
if (isset($getProj) && $getProj) mysqli_free_result($getProj);
// note: other results were freed/consumed during flow
?>
