<?php
    session_start();
    if(!isset($_SESSION['simple_login'])){
        header("Location: index.php");
        exit();
    }
	?>

<!DOCTYPE>
<head> 

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">  
    
    <meta name="title" content="ICS Global Soft Inc.">
    <meta name="description" content="ICS Global Soft Inc. specialize in the development of bespoke desktop and web based applications built to the specification of the customer.">
    <meta name="keywords" content="ICS Global Soft Inc., bespoke desktop applications, web based applications">
    <link rel="canonical" href="">
    <link rel="image_src" href="images/social-iconconsultancyservices.jpg">
    <meta property="og:title" content="ICS Global Soft Inc.">
    <meta property="og:type" content="article">
    <meta property="og:url" content="">
    <meta property="og:image" content="images/social-iconconsultancyservices.jpg">
    <meta property="og:site_name" content="ICS Global Soft Inc.">
    <meta property="og:description" content="ICS Global Soft Inc. specialize in the development of bespoke desktop and web based applications built to the specification of the customer.">
    <meta name="twitter:card" value="summary">
    <meta name="twitter:site" value="@Icon">
    <meta property="twitter:url" content="">
    <meta property="twitter:image" content="images/social-iconconsultancyservices.jpg">
    <meta property="twitter:title" content="ICS Global Soft Inc.">
    <meta property="twitter:description" content="ICS Global Soft Inc. specialize in the development of bespoke desktop and web based applications built to the specification of the customer. straight from the entertainment industry.">

    <title>Path Analysis | ICS Global Soft Inc.</title>
    
    <link rel="stylesheet" href="css/bootstrap.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="css/slick.css"/>
    <link rel="stylesheet" href="js/colorbox/colorbox.css"/>
    <link rel="stylesheet" href="css/style.css">
 	<style>
	a.sidemenu-link-5{ color:#082951; font-weight:700; }
	</style>
</head>



<body>



    <!-- Header starts -->
    <?php include("includes/header.php"); ?>  

<section class="content-row-white-1 clearfix"> 
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<h1>Path Analysis</h1> 
</div>
</div>
</section>

<section class="content-row-white clearfix">
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>Visualize Any Insurance Data Flow</h3>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>Engineers need to understand how Insurance data is flowing across the network. Traceroute provides limited value because it doesn’t function across modern technologies like policy-based routing and load balancing. Dynamic Path Analysis provides end-to-end visibility, across any network path for insurance policies.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/path-analysis.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>

<section class="content-row-white clearfix">
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>Deep Insurance protocol analysis</h3>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>Insurance Communication Network (ICN)’s A/B calculator performs a comprehensive analysis at every hop of the path, factoring advanced technologies like policy-based routing, NAT, access-lists, and much more in order to clear processing of insurances.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/deep-protocol.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>


<section class="content-row-white clearfix">
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>Logical and physical analysis</h3>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>With traceroute, interfaces are not known, only devices. With insurance communication network (ICN) engineers can visualize traffic flows from either a layer-3 (logical) or layer-2 (physical) perspective.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/logical-and-physical-analysis.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>

<section class="content-row-white clearfix">
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>Advanced analysis</h3>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>Multi-path routes are common in many networks today. Traceroute will only report on the path that was part of the probe messages. Insurance Communication Network (ICN) displays these equal paths visually.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/load-balancing.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>


<section class="content-row-white clearfix">
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>Asymmetric routing analysis</h3>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>Asymmetric paths are difficult to detect with a ping or traceroute. With insurance communication network (ICN), engineers can clearly visualize asymmetry.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/Asymmetric-routing-analysis.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>


<section class="content-row-white clearfix">
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>Historical path analysis</h3>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>When engineers are troubleshooting a slow application for policies, the first question is ‘what changed?’ With insurance communication network(ICN), the historical flow of an application can be mapped to see if it changed.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/historical-path-analysis.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>

	   <!-- Footer Starts -->
    <?php include("includes/footer.php"); ?>
    
</body>