<?php
    session_start();
    if(!isset($_SESSION['simple_login'])){
        header("Location: index.php");
        exit();
    }
	?>

<!DOCTYPE>
<head> 

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">  
    
    <meta name="title" content="ICS Global Soft Inc.">
    <meta name="description" content="ICS Global Soft Inc. specialize in the development of bespoke desktop and web based applications built to the specification of the customer.">
    <meta name="keywords" content="ICS Global Soft Inc., bespoke desktop applications, web based applications">
    <link rel="canonical" href="">
    <link rel="image_src" href="images/social-iconconsultancyservices.jpg">
    <meta property="og:title" content="ICS Global Soft Inc.">
    <meta property="og:type" content="article">
    <meta property="og:url" content="">
    <meta property="og:image" content="images/social-iconconsultancyservices.jpg">
    <meta property="og:site_name" content="ICS Global Soft Inc.">
    <meta property="og:description" content="ICS Global Soft Inc. specialize in the development of bespoke desktop and web based applications built to the specification of the customer.">
    <meta name="twitter:card" value="summary">
    <meta name="twitter:site" value="@Icon">
    <meta property="twitter:url" content="">
    <meta property="twitter:image" content="images/social-iconconsultancyservices.jpg">
    <meta property="twitter:title" content="ICS Global Soft Inc.">
    <meta property="twitter:description" content="ICS Global Soft Inc. specialize in the development of bespoke desktop and web based applications built to the specification of the customer. straight from the entertainment industry.">

    <title>How INAI Works | ICS Global Soft Inc.</title>
    
    <link rel="stylesheet" href="css/bootstrap.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="css/slick.css"/>
    <link rel="stylesheet" href="js/colorbox/colorbox.css"/>
    <link rel="stylesheet" href="css/style.css">
 	<style>
	a.sidemenu-link-3{ color:#1769b4; font-weight:700; }
	</style>
</head>

<body>



    <!-- Header starts -->
    <?php include("includes/header.php"); ?>  
      
<section class="content-row-white-1 clearfix"> 
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
   	<h1>How INAI Works</h1> 
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>To help INAI teams manage their premium, leads, and Claims policies, INAI uses the power of the Insurance process Map to deliver end-to-end visibility while integrating across IT workflows and with third-party systems (e.g., ticketing, SIEM, etc.) to automate insurance policies.</p>
</div>
</div>
</div>
</div>
</section>

<section class="content-row-white clearfix"> 
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>Four Phases of INAI Automation</h3> 
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-right">
<img src="images/inai.png" alt="netmon-image" class="welcome-image">
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-left">
<p><b>Intelligent discovery</b> – INAI discovers the network’s topology and underlying design.<br>
<b>A model of the network</b> – INAI builds a database of information to model the live network.<br>
<b>End-to-end visibility</b> – Users can map any part of the network on-demand with Dynamic Maps. These custom maps become the user interface for network automation and collaboration.<br>
<b>Automation</b> – Executable Runbooks can be customized to automate any insurance policy analysis or diagnosis, and also triggered-from third-party systems (e.g., ticketing, SIEM, etc.).<br>
</p>
</div>
</div>
</div>
</div>
</section>

<section class="content-row-white clearfix">
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>How Does INAI Collect Data From the Network?</h3>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>Almost everything INAI knows about the network is learned through Telnet or SSH. During the network discovery, INAI logs into every device it discovers to issue and analyze many CLI commands. INAI uses SNMP to identify the vendor make and model, so it knows the proper CLI syntax to execute. To kick off the discovery, INAI only needs the IP address of a core router or switch. It will learn the neighbors of that device via CDP, LLDP, and other protocols. This neighbor-walking discovery is very fast – discovering about 2,000 network devices per hour.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/live-network-descovery.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>

<section class="content-row-white clearfix"> 
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>What Information Does INAI Collect From the Live Network?</h3> 
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-right">
<img src="images/live-network.png" alt="netmon-image" class="welcome-image">
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-left">
<p>During the discovery, INAI collects information about the network’s topology as well as its underlying design – taking into account configuration, routing, MAC/ARP tables, MPLS design, and much more. The discovery provides a baseline of information which INAI uses to build its insurance policies maps. The information in the maps can be further enriched through live performance monitoring and customized with Executable Runbooks.</p>
</div>
</div>
</div>
</div>
</section>

<section class="content-row-white clearfix"> 
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>How Does INAI Dynamically Build a Map?</h3> 
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>As INAI performs the discovery, it creates a complex mathematical model of the network. This model serves as the “brain” of INAI, which is used to build every map. Each icon on a Dynamic Map is more than a stencil, it is data-driven, with dozens of attributes.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/dynamic-buld-map.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>


<section class="content-row-white clearfix"> 
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>How Does INAI Track Changes in the Network?</h3> 
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-right">
<img src="images/system-benchmark-properties.png" alt="netmon-image" class="welcome-image">
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-left">
<p>To prevent the network model from becoming obsolete, INAI performs a recurring re-discovery – a process known as a Benchmark. This Benchmark can be scheduled on the server at any frequency, and customized to include or exclude various network data.</p>
</div>
</div>
</div>
</div>
</section> 

 <section class="content-row-white clearfix"> 
 <div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>How Does INAI Support Customization as an Open Platform?</h3> 
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>The data which INAI pulls from the live network can be enhanced and customized through Executable Runbooks. Runbooks support additional logic to generate alarms, annotate the map, or create reports automatically. These runbooks can be built or customized through NetMon’s visual programming environment, without any scripting. To support new network devices and operating systems, INAI includes a plug-n-play device driver tool.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/excute-app.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>

<section class="content-row-white clearfix"> 
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>How Does INAI Handle Data From Other NMS Sources?</h3> 
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-right">
<img src="images/nms-sourses.png" alt="netmon-image" class="welcome-image">
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-left">
<p>INAI retrieves data primarily through telnet and SNMP but also offers easy API integration for inventory data queries and updates through other Network Management Solutions.</p>
</div>
</div>
</div>
</div>
</section> 

 <section class="content-row-white clearfix"> 
 <div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>How Is INAI Deployed on the Network?</h3> 
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>INAI Enterprise Edition has five components: Customer Policies Server, Premium policies Server, Automation Server, Network Server and the Workstation.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/dynamic-buld-map.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>
    <!-- Footer Starts -->
    <?php include("includes/footer.php"); ?>
    
</body>