<?php
    session_start();
    if(!isset($_SESSION['simple_login'])){
        header("Location: index.php");
        exit();
    }
	?>

<!DOCTYPE>
<head> 

    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">  
    
    <meta name="title" content="ICS Global Soft Inc.">
    <meta name="description" content="ICS Global Soft Inc. specialize in the development of bespoke desktop and web based applications built to the specification of the customer.">
    <meta name="keywords" content="ICS Global Soft Inc., bespoke desktop applications, web based applications">
    <link rel="canonical" href="">
    <link rel="image_src" href="images/social-iconconsultancyservices.jpg">
    <meta property="og:title" content="ICS Global Soft Inc.">
    <meta property="og:type" content="article">
    <meta property="og:url" content="">
    <meta property="og:image" content="images/social-iconconsultancyservices.jpg">
    <meta property="og:site_name" content="ICS Global Soft Inc.">
    <meta property="og:description" content="ICS Global Soft Inc. specialize in the development of bespoke desktop and web based applications built to the specification of the customer.">
    <meta name="twitter:card" value="summary">
    <meta name="twitter:site" value="@Icon">
    <meta property="twitter:url" content="">
    <meta property="twitter:image" content="images/social-iconconsultancyservices.jpg">
    <meta property="twitter:title" content="ICS Global Soft Inc.">
    <meta property="twitter:description" content="ICS Global Soft Inc. specialize in the development of bespoke desktop and web based applications built to the specification of the customer. straight from the entertainment industry.">

    <title>Executable Runbook | ICS Global Soft Inc.</title>
    
    <link rel="stylesheet" href="css/bootstrap.css">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
    <link rel="stylesheet" href="css/slick.css"/>
    <link rel="stylesheet" href="js/colorbox/colorbox.css"/>
    <link rel="stylesheet" href="css/style.css">
 	
    <style>
	a.sidemenu-link-6{ color:#082951; font-weight:700; }
	</style>
     
</head>



<body>



    <!-- Header starts -->
    <?php include("includes/header.php"); ?>  


<section class="content-row-white-1 clearfix"> 
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
   	<h1>Executable Runbook</h1> 
</div>
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<h3>Automate Insurance Management</h3> 
<p>Many organizations leverage playbooks to implement policies and procedures such as troubleshooting guides or security checklists. These playbooks are difficult to implement because they are manual. ICN’s Executable Runbooks, empower teams with a reusable methodology, powered by automation.</p>
</div>
</div>
</div>
</section>

<section class="content-row-white clearfix">
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>Automate Insurance Policies Management</h3>
</div>
<div class="col-md-12 col-sm-12 col-xs-12">
	 <table class="table table-bordered">
    <thead>
      <tr>
        <th>Criteria</th>
        <th>Executable Runbook</th>
        <th>Static Playbook</th>
      </tr>
    </thead>
    <tbody>
      <tr>
        <td>Digital Process</td>
       <td><img src="images/right-tic.png" alt="right-image"></td>
        <td><img src="images/right-tic.png" alt="right-image"></td>
      </tr>
      <tr>
        <td>Track Results</td>
       <td><img src="images/right-tic.png" alt="right-image"></td>
        <td><img src="images/into-mark.png" alt="right-image"></td>
      </tr>
      <tr>
        <td>Executable</td>
        <td><img src="images/right-tic.png" alt="right-image"></td>
        <td><img src="images/into-mark.png" alt="right-image"></td>
      </tr>
   <tr>
        <td>Trigger via API</td>
        <td><img src="images/right-tic.png" alt="right-image"></td>
        <td><img src="images/into-mark.png" alt="right-image"></td>
      </tr>
   <tr>
        <td>Community Backed</td>
        <td><img src="images/right-tic.png" alt="right-image"></td>
        <td><img src="images/into-mark.png" alt="right-image"></td>
      </tr>
    </tbody>
  </table>
</div>
</div>
</section>


<section class="content-row-white clearfix">
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>Digitize best Insurance policies</h3>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>Executable Runbooks are fully programmable, by programmers and non-programmers alike, providing a framework for teams to translate best practices into repeatable and executable processes</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/digitize-best-practices.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>


<section class="content-row-white clearfix">
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>Automate any task</h3>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>Executable Runbooks arm network teams with network automation which can be used for any task for the insurance policies. Every runbook step is executable, saving engineers valuable time.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/automatick-any-task.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>

<section class="content-row-white clearfix">
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>Track results in runbook</h3>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>Data collected by runbook is automatically embedded inside, for review and analysis. Runbook results are attached to the Dynamic Map for the insurance services, which can be shared as a single URL.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/view-runbook-results.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>




<section class="content-row-white clearfix">
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>Trigger runbooks via API</h3>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>Through Insurance Communication Network (ICN)’s rich API framework, third party NMS solutions (e.g. monitoring or ticketing systems) can trigger a runbook analysis without human intervention.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/third-party-nms.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>


<section class="content-row-white clearfix">
<div class="container">
<div class="col-md-12 col-sm-12 col-xs-12">
<div class="col-md-12 col-sm-12 col-xs-12">
<h3>Runbook community</h3>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-header inside-right">
<p>Every runbook is a set of knowledge which can be broadly leveraged. Insurance Communication Network (ICN)’s Runbook Center provides an online community where ICN users can share and download runbooks to enrich their workflows in insurances.</p>
</div>
</div>
<div class="col-md-6 col-sm-12 col-xs-12">
<div class="welcome-image-wrapper inside-left">
<img src="images/runbook-center.png" alt="netmon-image" class="welcome-image">
</div>
</div>
</div>
</div>
</section>
	   <!-- Footer Starts -->
    <?php include("includes/footer.php"); ?>
    
</body>